/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.srvutil;

import com.ibm.hsc.auiml.databeans.sfp.srvutil.RemoveIOBean;
import com.ibm.hsc.auiml.databeans.sfp.srvutil.ServiceUtilConstants;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIIODrawerConfigIdDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hsc.websm.sfp.ServiceUtilitiesTarget;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class RemoveIOTasklet
extends TargetedTasklet
implements ServiceUtilConstants {
    private static final String TRACE_MASKD = "JRMIOTKD";
    private static final String TRACE_MASKF = "JRMIOTKF";
    private static final String TRACE_MASKT = "JRMIOTKT";
    private static final short ERRID_0065 = 101;
    private static final short ERRID_0066 = 102;
    private static final short ERRID_0067 = 103;
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, -128, "SFPUtilRMIO");
    private static final String AUIML_FILE_NAME = "com.ibm.hsc.auiml.databeans.sfp.srvutil.RemoveIO";
    private static final String REMOVE_IO_PANEL = "RemoveIODrawer";
    private String userDefinedName = null;
    private static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    private PIHSCCECClient r5Client = null;

    public RemoveIOTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> RemoveIOTasklet c-tor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> RemoveIOTasklet.service()");
        if (panelTaskletRequest.isInitialRequest()) {
            Trace.trace((String)TRACE_MASKF, (Object)"-> RemoveIOTasklet.isInitialRequest()");
            RemoveIOBean removeIOBean = new RemoveIOBean();
            removeIOBean.setBeanName("RemoveIOBean");
            Target[] targetArray = this.getSelectedTargets();
            String string = targetArray[0].getName().toString();
            Trace.trace((String)TRACE_MASKF, (Object)("-- selected system name is: " + string));
            Object object = ((ServiceUtilitiesTarget)targetArray[0]).getTargetObject();
            if (object instanceof PICec) {
                this.userDefinedName = ((PICec)object).getUserDefinedName();
                Trace.trace((String)TRACE_MASKF, (Object)("-- userDefinedName is: " + this.userDefinedName));
                if (string != null && string.length() != 0) {
                    removeIOBean.setSelectedSystem(string);
                }
                if (this.userDefinedName != null && this.userDefinedName.length() != 0) {
                    removeIOBean.setUserDefinedName(this.userDefinedName);
                }
                try {
                    this.showBusyDialog(new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_ENCLOSURE_TITLE"), new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_ENCLOSURE_TEXT"));
                    this.getInstalledEnclosureInfo(removeIOBean, this.userDefinedName);
                    panelTaskletResponse.openModalChild(AUIML_FILE_NAME, REMOVE_IO_PANEL, (PanelBean)removeIOBean);
                    this.destroyBusyDialog();
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKD, (Object)("-- unexpected exception querying FRUs: " + exception));
                    this.destroyBusyDialog();
                    new AusMicrocodeLog(_logInfo, 101, exception).writeEntry(null);
                    Trace.trace((String)TRACE_MASKF, (Object)("-- Message is " + exception.getMessage()));
                    String string2 = exception.getMessage().equals("CIMNullClient") ? "0242" : (exception instanceof UnknownHostException ? "0241" : (exception instanceof PIHscClientException ? "0243" : "0245"));
                    Trace.trace((String)TRACE_MASKF, (Object)("-- key is " + string2));
                    try {
                        SFPUtil.showSFPErrorMessageBox(string2, (PanelTasklet)this);
                    }
                    catch (Exception exception2) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- showSFPErrorMessageBox() exception caught, e is" + exception2));
                    }
                    try {
                        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, REMOVE_IO_PANEL, (PanelBean)removeIOBean);
                    }
                    catch (Exception exception3) {
                        Trace.trace((String)TRACE_MASKF, (Object)("Another exception caught during initial service request, e1 is " + exception3));
                        panelTaskletResponse.terminate();
                    }
                }
            } else {
                panelTaskletResponse.noAction();
            }
            Trace.trace((String)TRACE_MASKT, (Object)"<- RemoveIOTasklet.service()");
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)("taskletRequest.getData(command): " + panelTaskletRequest.getData("Command") + "."));
            if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                Trace.trace((String)TRACE_MASKF, (Object)"taskletRequest.isDisposed() or isCanceled, issue taskletResponse.dispose().");
                panelTaskletResponse.dispose();
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Some taskletRequest other than Cancel is pending.");
                String string = (String)panelTaskletRequest.getData("Command");
                Trace.trace((String)TRACE_MASKF, (Object)("Command is " + string));
                if (string == null) {
                    panelTaskletResponse.noAction();
                }
                if (string.equals("DisownButton") || string.equals("COMPLETE")) {
                    Trace.trace((String)TRACE_MASKF, (Object)"Commit button found tasklet side.");
                    try {
                        RemoveIOBean removeIOBean = (RemoveIOBean)panelTaskletRequest.getData("DataBean");
                        if (removeIOBean != null) {
                            int n = removeIOBean.getEnclosureTableSelection()[0];
                            Trace.trace((String)TRACE_MASKF, (Object)("Selected row is " + n));
                            PIIODrawerConfigIdDataBean pIIODrawerConfigIdDataBean = removeIOBean.getEnclosureInfo()[n];
                            String string3 = pIIODrawerConfigIdDataBean.getLoaction_code();
                            Trace.trace((String)TRACE_MASKF, (Object)("selected loccode is " + string3));
                        }
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, e is" + exception));
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)"-- before noAction return");
                    panelTaskletResponse.noAction();
                } else {
                    Trace.trace((String)TRACE_MASKT, (Object)"Unknown tasklet request sent to ReplaceFRUTasklet.");
                    panelTaskletResponse.noAction();
                }
            }
            Trace.trace((String)TRACE_MASKT, (Object)"<- RemoveIOTasklet.service()");
        }
    }

    public void getInstalledEnclosureInfo(RemoveIOBean removeIOBean, String string) throws Exception {
        block5: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> RemoveIOTasklet.getAllEnclosureInfo()");
            try {
                this.r5Client = this.createCECClient(string);
                if (null != this.r5Client) {
                    try {
                        this.getAllEnclosureInfo(this.r5Client, removeIOBean);
                        Trace.trace((String)TRACE_MASKD, (Object)"-- getAllSysInfo() completed successfully");
                        break block5;
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught during getAllSysInfo(), exception is: " + exception));
                        throw exception;
                    }
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- could not create the CEC CIM client");
                throw new Exception("CIMNullClient");
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, rethrowing..." + exception));
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- RemoveIOTasklet.getAllEnclosureInfo()");
    }

    private PIHSCCECClient createCECClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> RemoveIOTasklet.createCECClient()");
        PIHSCCECClient pIHSCCECClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                String string3 = string;
                Trace.trace((String)TRACE_MASKD, (Object)("-- theSystem (selected system name) is: " + string3));
                pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string3, false);
                Trace.trace((String)TRACE_MASKF, (Object)("r5Client (after createCECClient()) " + pIHSCCECClient));
                if (null == pIHSCCECClient) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- Cannot create PIHSCCECClient - client is null");
                    try {
                        throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "MANAGED_SYSTEM_NOT_FOUND", null, null);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Could not throw new PIHscClientException, exception is: " + exception));
                        throw exception;
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5Client is: " + exception));
                throw exception;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- RemoveIOTasklet.createCECClient()");
        return pIHSCCECClient;
    }

    protected void getAllEnclosureInfo(PIHSCCECClient pIHSCCECClient, RemoveIOBean removeIOBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> RemoveIOTasklet.getAllEnclosureInfo()");
        PIIODrawerConfigIdDataBean[] pIIODrawerConfigIdDataBeanArray = null;
        try {
            pIIODrawerConfigIdDataBeanArray = pIHSCCECClient.getIoDrawerConfigIdAndMtms(PIIODrawerConfigIdDataBean.ALL_KEYS);
            Trace.trace((String)TRACE_MASKF, (Object)("-- Number of PIIODrawerConfigIdDataBeans returned is " + pIIODrawerConfigIdDataBeanArray.length));
            if (pIIODrawerConfigIdDataBeanArray != null && pIIODrawerConfigIdDataBeanArray.length > 0) {
                removeIOBean.setEnclosureInfo(pIIODrawerConfigIdDataBeanArray);
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getAllEnclosureInfo() cmd. Exception is: " + exception));
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- RemoveIOTasklet.getAllEnclosureInfo()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> RemoveIOTasklet.logException()");
        Trace.trace((String)TRACE_MASKT, (Object)("processing exception: " + throwable));
        HException hException = new HException(throwable);
        Trace.trace((String)TRACE_MASKT, (Object)"<- RemoveIOTasklet.logException()");
    }
}

